/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.flexgen.example.FullMapRenderer;
import org.flexgen.example.GrowingMapTileLocationFilter;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTile;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileEdge;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileLocationFilter;
import org.flexgen.map.MapTileOrientation;
import org.flexgen.map.MapTileRemovedListener;
import org.flexgen.map.MapTileType;
import org.flexgen.map.MapUnit;
import org.flexgen.map.RectangularMapTileLocationFilter;
import org.flexgen.util.ImprovedRandom;

public class RiverExample {
    private static final MapUnit GRASS = new MapUnit("Grass");
    private static final MapUnit RIVER = new MapUnit("River");
    private static final MapTileEdge GRASS_EDGE = new MapTileEdge("Grass Edge");
    private static final MapTileEdge RIVER_EDGE = new MapTileEdge("River Edge");
    private static final MapTileType ALL_GRASS = new MapTileType("All Grass", 5000, (MapUnit[][])new MapUnit[][]{{GRASS, GRASS, GRASS}, {GRASS, GRASS, GRASS}, {GRASS, GRASS, GRASS}}, new MapTileEdge[]{GRASS_EDGE, GRASS_EDGE, GRASS_EDGE, GRASS_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT});
    private static final MapTileType STRAIGHT_RIVER = new MapTileType("Straight River", 1000, (MapUnit[][])new MapUnit[][]{{GRASS, RIVER, GRASS}, {GRASS, RIVER, GRASS}, {GRASS, RIVER, GRASS}}, new MapTileEdge[]{RIVER_EDGE, GRASS_EDGE, RIVER_EDGE, GRASS_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE});
    private static final MapTileType CORNER_RIVER = new MapTileType("Corner River", 500, (MapUnit[][])new MapUnit[][]{{GRASS, RIVER, GRASS}, {GRASS, RIVER, RIVER}, {GRASS, GRASS, GRASS}}, new MapTileEdge[]{RIVER_EDGE, RIVER_EDGE, GRASS_EDGE, GRASS_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE});
    private static final MapTileType THREE_WAY_RIVER = new MapTileType("Three Way River", 250, (MapUnit[][])new MapUnit[][]{{GRASS, RIVER, GRASS}, {RIVER, RIVER, RIVER}, {GRASS, GRASS, GRASS}}, new MapTileEdge[]{RIVER_EDGE, RIVER_EDGE, GRASS_EDGE, RIVER_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE});
    private static final MapTileType FOUR_WAY_RIVER = new MapTileType("Four Way River", 100, (MapUnit[][])new MapUnit[][]{{GRASS, RIVER, GRASS}, {RIVER, RIVER, RIVER}, {GRASS, RIVER, GRASS}}, new MapTileEdge[]{RIVER_EDGE, RIVER_EDGE, RIVER_EDGE, RIVER_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT});
    private static final MapTileType DEAD_END_RIVER = new MapTileType("Dead End River", 1, (MapUnit[][])new MapUnit[][]{{GRASS, RIVER, GRASS}, {GRASS, GRASS, GRASS}, {GRASS, GRASS, GRASS}}, new MapTileEdge[]{RIVER_EDGE, GRASS_EDGE, GRASS_EDGE, GRASS_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE});
    private static final MapTileType[] MAP_TILE_TYPES = new MapTileType[]{ALL_GRASS, STRAIGHT_RIVER, CORNER_RIVER, THREE_WAY_RIVER, FOUR_WAY_RIVER, DEAD_END_RIVER};
    private static final Map<MapUnit, Color> COLOR_MAP = new HashMap<MapUnit, Color>();

    public static void main(String[] args) {
        System.out.println("FlexGen : Flexible Map Generator Library");
        System.out.println();
        System.out.println("Example Application - Grass and Rivers");
        String dirName = "target/worlds/River";
        File dir = new File(dirName);
        dir.mkdirs();
        GrowingMapTileLocationFilter growingMapTileLocationFilter = new GrowingMapTileLocationFilter((MapTileLocationFilter)new RectangularMapTileLocationFilter(-10, -10, 10, 10));
        MapGenerator mapGenerator = new MapGenerator(new ImprovedRandom(), MAP_TILE_TYPES, (MapTileLocationFilter)growingMapTileLocationFilter);
        FullMapRenderer fullMapRenderer = new FullMapRenderer(dirName + "/", 5, COLOR_MAP);
        mapGenerator.addMapTileAddedListener((MapTileAddedListener)fullMapRenderer);
        mapGenerator.addMapTileRemovedListener((MapTileRemovedListener)fullMapRenderer);
        mapGenerator.addMapTile(new MapTileLocation(0, 0), new MapTile(ALL_GRASS, MapTileOrientation.UPRIGHT));
        mapGenerator.generate();
    }

    private RiverExample() {
    }

    static {
        COLOR_MAP.put(GRASS, new Color(0, 255, 0));
        COLOR_MAP.put(RIVER, new Color(0, 0, 255));
    }
}

