/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.imageio.ImageIO;
import org.flexgen.example.MapRendererHelper;
import org.flexgen.map.BeforeMapTileAddedListener;
import org.flexgen.map.BeforeMapTileRemovedListener;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileRemovedListener;
import org.flexgen.map.MapUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialMapRenderer
implements BeforeMapTileAddedListener,
BeforeMapTileRemovedListener,
MapTileAddedListener,
MapTileRemovedListener {
    private final String fileNamePrefix;
    private final int mapUnitSize;
    private final Map<MapUnit, Color> colorMap;
    private final int width;
    private final int height;
    private int focusX;
    private int focusY;

    public PartialMapRenderer(String fileNamePrefix, int mapUnitSize, Map<MapUnit, Color> colorMap, int width, int height) {
        this.fileNamePrefix = fileNamePrefix;
        this.mapUnitSize = mapUnitSize;
        this.colorMap = colorMap;
        this.width = width;
        this.height = height;
        this.focusX = 0;
        this.focusY = 0;
    }

    public void beforeMapTileAdded(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.adjustFocus(mapGenerator, mapTileLocation);
    }

    public void beforeMapTileRemoved(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.adjustFocus(mapGenerator, mapTileLocation);
    }

    public void mapTileAdded(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.render(mapGenerator, mapTileLocation);
    }

    public void mapTileRemoved(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.render(mapGenerator, mapTileLocation);
    }

    private void adjustFocus(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        while (Math.abs(this.focusX - mapTileLocation.getX()) > 1 || Math.abs(this.focusY - mapTileLocation.getY()) > 1) {
            if (mapTileLocation.getX() > this.focusX) {
                ++this.focusX;
            }
            if (mapTileLocation.getX() < this.focusX) {
                --this.focusX;
            }
            if (mapTileLocation.getY() > this.focusY) {
                ++this.focusY;
            }
            if (mapTileLocation.getY() < this.focusY) {
                --this.focusY;
            }
            this.render(mapGenerator, new MapTileLocation(this.focusX, this.focusY));
        }
    }

    private void render(MapGenerator mapGenerator, MapTileLocation centerMapTileLocation) {
        this.focusX = centerMapTileLocation.getX();
        this.focusY = centerMapTileLocation.getY();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        GregorianCalendar now = new GregorianCalendar();
        String fileName = this.fileNamePrefix + dateFormat.format(now.getTime()) + ".png";
        int minX = centerMapTileLocation.getX() - this.width / 2;
        int minY = centerMapTileLocation.getY() - this.height / 2;
        int maxX = centerMapTileLocation.getX() + this.width / 2;
        int maxY = centerMapTileLocation.getY() + this.height / 2;
        int pixelCount = this.mapUnitSize * mapGenerator.getTileSize();
        BufferedImage image = MapRendererHelper.getMapAsImage(mapGenerator, minX, minY, maxX, maxY, this.mapUnitSize, this.colorMap);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRect(this.width / 2 * pixelCount - 1, this.height / 2 * pixelCount - 1, pixelCount + 1, pixelCount + 1);
        try {
            File file = new File(fileName);
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

