/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTile;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRendererHelper {
    public static BufferedImage getMapAsImage(MapGenerator mapGenerator, int minX, int minY, int maxX, int maxY, int mapUnitSize, Map<MapUnit, Color> colorMap) {
        int tileSize = mapGenerator.getTileSize();
        BufferedImage image = new BufferedImage((maxX - minX + 1) * tileSize * mapUnitSize, (maxY - minY + 1) * tileSize * mapUnitSize, 1);
        Graphics2D graphics = image.createGraphics();
        for (int tileY = minY; tileY <= maxY; ++tileY) {
            for (int tileX = minX; tileX <= maxX; ++tileX) {
                MapTileLocation mapTileLocation = new MapTileLocation(tileX, tileY);
                MapTile mapTile = mapGenerator.getMapTile(mapTileLocation);
                for (int unitY = 0; unitY < tileSize; ++unitY) {
                    for (int unitX = 0; unitX < tileSize; ++unitX) {
                        Color color = null;
                        if (mapTile != null) {
                            MapUnit mapUnit = mapTile.getMapUnit(unitX, unitY);
                            color = colorMap.get(mapUnit);
                        }
                        if (color == null) {
                            color = new Color(0, 0, 0);
                        }
                        graphics.setColor(color);
                        int renderX = ((tileX - minX) * tileSize + unitX) * mapUnitSize;
                        int renderY = ((tileY - minY) * tileSize + unitY) * mapUnitSize;
                        graphics.fillRect(renderX, renderY, mapUnitSize, mapUnitSize);
                    }
                }
            }
        }
        return image;
    }

    private MapRendererHelper() {
    }
}

