/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.util.Collection;
import java.util.LinkedList;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileLocationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMapTileLocationFilter
implements MapTileLocationFilter,
MapTileAddedListener {
    private final MapTileLocationFilter mapTileLocationFilter;
    private MapTileLocation lastMapTileLocation;

    public LocalMapTileLocationFilter(MapTileLocationFilter mapTileLocationFilter) {
        this.mapTileLocationFilter = mapTileLocationFilter;
    }

    public int getMinX() {
        return this.mapTileLocationFilter.getMinX();
    }

    public int getMinY() {
        return this.mapTileLocationFilter.getMinY();
    }

    public int getMaxX() {
        return this.mapTileLocationFilter.getMaxX();
    }

    public int getMaxY() {
        return this.mapTileLocationFilter.getMaxY();
    }

    public Collection<MapTileLocation> getFilteredMapTileLocations(Collection<MapTileLocation> mapTileLocations) {
        Collection rawMapTileLocations = this.mapTileLocationFilter.getFilteredMapTileLocations(mapTileLocations);
        LinkedList<MapTileLocation> localMapTileLocations = new LinkedList<MapTileLocation>();
        int maxDistance = 1;
        if (!rawMapTileLocations.isEmpty()) {
            while (localMapTileLocations.isEmpty()) {
                for (MapTileLocation mapTileLocation : rawMapTileLocations) {
                    int distance = Math.abs(this.lastMapTileLocation.getX() - mapTileLocation.getX()) + Math.abs(this.lastMapTileLocation.getY() - mapTileLocation.getY());
                    if (distance > maxDistance) continue;
                    localMapTileLocations.add(mapTileLocation);
                }
                maxDistance *= 2;
            }
        }
        return localMapTileLocations;
    }

    public void mapTileAdded(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.lastMapTileLocation = mapTileLocation;
    }
}

