/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.util.Collection;
import java.util.LinkedList;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileLocationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowingMapTileLocationFilter
implements MapTileLocationFilter {
    private final MapTileLocationFilter mapTileLocationFilter;
    private int maxDistance;

    public GrowingMapTileLocationFilter(MapTileLocationFilter mapTileLocationFilter) {
        this.mapTileLocationFilter = mapTileLocationFilter;
    }

    public int getMinX() {
        return this.mapTileLocationFilter.getMinX();
    }

    public int getMinY() {
        return this.mapTileLocationFilter.getMinY();
    }

    public int getMaxX() {
        return this.mapTileLocationFilter.getMaxX();
    }

    public int getMaxY() {
        return this.mapTileLocationFilter.getMaxY();
    }

    public Collection<MapTileLocation> getFilteredMapTileLocations(Collection<MapTileLocation> mapTileLocations) {
        Collection rawMapTileLocations = this.mapTileLocationFilter.getFilteredMapTileLocations(mapTileLocations);
        LinkedList<MapTileLocation> localMapTileLocations = new LinkedList<MapTileLocation>();
        if (!rawMapTileLocations.isEmpty()) {
            while (localMapTileLocations.isEmpty()) {
                for (MapTileLocation mapTileLocation : rawMapTileLocations) {
                    int distance = Math.max(Math.abs(mapTileLocation.getX()), Math.abs(mapTileLocation.getY()));
                    if (distance > this.maxDistance) continue;
                    localMapTileLocations.add(mapTileLocation);
                }
                if (!localMapTileLocations.isEmpty()) continue;
                ++this.maxDistance;
            }
        }
        return localMapTileLocations;
    }
}

