/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.imageio.ImageIO;
import org.flexgen.example.MapRendererHelper;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileRemovedListener;
import org.flexgen.map.MapUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullMapRenderer
implements MapTileAddedListener,
MapTileRemovedListener {
    private final String fileNamePrefix;
    private final int mapUnitSize;
    private final Map<MapUnit, Color> colorMap;

    public FullMapRenderer(String fileNamePrefix, int mapUnitSize, Map<MapUnit, Color> colorMap) {
        this.fileNamePrefix = fileNamePrefix;
        this.mapUnitSize = mapUnitSize;
        this.colorMap = colorMap;
    }

    public void mapTileAdded(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.render(mapGenerator);
    }

    public void mapTileRemoved(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.render(mapGenerator);
    }

    private void render(MapGenerator mapGenerator) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        GregorianCalendar now = new GregorianCalendar();
        String fileName = this.fileNamePrefix + dateFormat.format(now.getTime()) + ".png";
        int minX = mapGenerator.getMinX();
        int minY = mapGenerator.getMinY();
        int maxX = mapGenerator.getMaxX();
        int maxY = mapGenerator.getMaxY();
        BufferedImage image = MapRendererHelper.getMapAsImage(mapGenerator, minX, minY, maxX, maxY, this.mapUnitSize, this.colorMap);
        try {
            File file = new File(fileName);
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

