/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.flexgen.example.DoorwayMapTileLocationFilter;
import org.flexgen.example.LocalMapTileLocationFilter;
import org.flexgen.example.PartialMapRenderer;
import org.flexgen.map.BeforeMapTileAddedListener;
import org.flexgen.map.BeforeMapTileRemovedListener;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTile;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileEdge;
import org.flexgen.map.MapTileEdgePosition;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileLocationFilter;
import org.flexgen.map.MapTileOrientation;
import org.flexgen.map.MapTileRemovedListener;
import org.flexgen.map.MapTileType;
import org.flexgen.map.MapUnit;
import org.flexgen.util.ImprovedRandom;

public class DungeonExample {
    public static final MapUnit FLOOR_UNIT = new MapUnit("Floor");
    public static final MapUnit WALL_UNIT = new MapUnit("Wall");
    public static final MapUnit DOOR_UNIT = new MapUnit("Door");
    public static final MapTileEdge OPEN_EDGE = new MapTileEdge("Open");
    public static final MapTileEdge LEFT_WALL_EDGE = new MapTileEdge("Left Wall");
    public static final MapTileEdge RIGHT_WALL_EDGE = new MapTileEdge("Right Wall");
    public static final MapTileEdge WALL_EDGE = new MapTileEdge("All Wall");
    public static final MapTileEdge HALLWAY_EDGE = new MapTileEdge("Hallway");
    public static final MapTileEdge DOORWAY_EDGE = new MapTileEdge("Doorway");
    public static final MapTileType OPEN_FLOOR_TYPE;
    public static final MapTileType ONE_CORNER_WALL_TYPE;
    public static final MapTileType TWO_CORNER_WALL_TYPE;
    public static final MapTileType WALL_TYPE;
    public static final MapTileType DOORWAY_TYPE;
    public static final MapTileType CORNER_TYPE;
    public static final MapTileType RIGHT_DOOR_CORNER_TYPE;
    public static final MapTileType LEFT_DOOR_CORNER_TYPE;
    public static final MapTileType TWO_DOOR_CORNER_TYPE;
    public static final MapTileType STRAIGHT_HALLWAY_TYPE;
    public static final MapTileType CORNER_HALLWAY_TYPE;
    public static final MapTileType THREE_WAY_HALLWAY_TYPE;
    public static final MapTileType FOUR_WAY_HALLWAY_TYPE;
    private static final MapTileType[] MAP_TILE_TYPES;
    private static final Map<MapUnit, Color> COLOR_MAP;

    public static void main(String[] args) {
        System.out.println("FlexGen : Flexible Map Generator Library");
        System.out.println();
        System.out.println("Example Application - Dungeon");
        String dirName = "target/worlds/Dungeon";
        File dir = new File(dirName);
        dir.mkdirs();
        DoorwayMapTileLocationFilter doorwayMapTileLocationFilter = new DoorwayMapTileLocationFilter();
        LocalMapTileLocationFilter localMapTileLocationFilter = new LocalMapTileLocationFilter(doorwayMapTileLocationFilter);
        MapGenerator mapGenerator = new MapGenerator(new ImprovedRandom(), MAP_TILE_TYPES, (MapTileLocationFilter)localMapTileLocationFilter);
        PartialMapRenderer partialMapRenderer = new PartialMapRenderer(dirName + "/", 5, COLOR_MAP, 20, 20);
        mapGenerator.addBeforeMapTileAddedListener((BeforeMapTileAddedListener)partialMapRenderer);
        mapGenerator.addBeforeMapTileRemovedListener((BeforeMapTileRemovedListener)partialMapRenderer);
        mapGenerator.addMapTileAddedListener((MapTileAddedListener)partialMapRenderer);
        mapGenerator.addMapTileAddedListener((MapTileAddedListener)doorwayMapTileLocationFilter);
        mapGenerator.addMapTileAddedListener((MapTileAddedListener)localMapTileLocationFilter);
        mapGenerator.addMapTileRemovedListener((MapTileRemovedListener)partialMapRenderer);
        mapGenerator.addMapTileRemovedListener((MapTileRemovedListener)doorwayMapTileLocationFilter);
        mapGenerator.addMapTile(new MapTileLocation(0, 0), new MapTile(OPEN_FLOOR_TYPE, MapTileOrientation.UPRIGHT));
        for (int i = 0; i < 5; ++i) {
            doorwayMapTileLocationFilter.clear();
            mapGenerator.generate();
        }
    }

    private DungeonExample() {
    }

    static {
        LEFT_WALL_EDGE.addMatchingMapTileEdge(RIGHT_WALL_EDGE);
        RIGHT_WALL_EDGE.addMatchingMapTileEdge(LEFT_WALL_EDGE);
        DOORWAY_EDGE.addMatchingMapTileEdge(HALLWAY_EDGE);
        HALLWAY_EDGE.addMatchingMapTileEdge(HALLWAY_EDGE);
        HALLWAY_EDGE.addMatchingMapTileEdge(DOORWAY_EDGE);
        OPEN_FLOOR_TYPE = new MapTileType("Open Floor", 1000, (MapUnit[][])new MapUnit[][]{{FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{OPEN_EDGE, OPEN_EDGE, OPEN_EDGE, OPEN_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        ONE_CORNER_WALL_TYPE = new MapTileType("One Corner Wall", 100, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{LEFT_WALL_EDGE, OPEN_EDGE, OPEN_EDGE, RIGHT_WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        TWO_CORNER_WALL_TYPE = new MapTileType("Two Corner Wall", 50, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, WALL_UNIT}}, new MapTileEdge[]{LEFT_WALL_EDGE, RIGHT_WALL_EDGE, LEFT_WALL_EDGE, RIGHT_WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        WALL_TYPE = new MapTileType("Wall", 1000, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, WALL_UNIT, WALL_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{WALL_EDGE, LEFT_WALL_EDGE, OPEN_EDGE, RIGHT_WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        DOORWAY_TYPE = new MapTileType("Doorway", 100, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, DOOR_UNIT, WALL_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{DOORWAY_EDGE, LEFT_WALL_EDGE, OPEN_EDGE, RIGHT_WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        CORNER_TYPE = new MapTileType("Corner", 500, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, WALL_UNIT, WALL_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{WALL_EDGE, LEFT_WALL_EDGE, RIGHT_WALL_EDGE, WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM});
        RIGHT_DOOR_CORNER_TYPE = new MapTileType("Right Door Corner", 50, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, DOOR_UNIT, WALL_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{DOORWAY_EDGE, LEFT_WALL_EDGE, RIGHT_WALL_EDGE, WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM});
        LEFT_DOOR_CORNER_TYPE = new MapTileType("Left Door Corner", 50, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, WALL_UNIT, WALL_UNIT}, {DOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{WALL_EDGE, LEFT_WALL_EDGE, RIGHT_WALL_EDGE, DOORWAY_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        TWO_DOOR_CORNER_TYPE = new MapTileType("Two Door Corner", 25, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, DOOR_UNIT, WALL_UNIT}, {DOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}}, new MapTileEdge[]{DOORWAY_EDGE, LEFT_WALL_EDGE, RIGHT_WALL_EDGE, DOORWAY_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        STRAIGHT_HALLWAY_TYPE = new MapTileType("Straight Hallway", 1500, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, WALL_UNIT}, {WALL_UNIT, FLOOR_UNIT, WALL_UNIT}, {WALL_UNIT, FLOOR_UNIT, WALL_UNIT}}, new MapTileEdge[]{HALLWAY_EDGE, WALL_EDGE, HALLWAY_EDGE, WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.BOTTOM});
        CORNER_HALLWAY_TYPE = new MapTileType("Corner Hallway", 300, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, WALL_UNIT}, {WALL_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, WALL_UNIT, WALL_UNIT}}, new MapTileEdge[]{HALLWAY_EDGE, HALLWAY_EDGE, WALL_EDGE, WALL_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT});
        THREE_WAY_HALLWAY_TYPE = new MapTileType("Three-Way Hallway", 50, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, WALL_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, WALL_UNIT, WALL_UNIT}}, new MapTileEdge[]{HALLWAY_EDGE, HALLWAY_EDGE, WALL_EDGE, HALLWAY_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT, MapTileOrientation.CLOCKWISE, MapTileOrientation.FLIPPED, MapTileOrientation.COUNTER_CLOCKWISE}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.LEFT});
        FOUR_WAY_HALLWAY_TYPE = new MapTileType("Four-Way Hallway", 25, (MapUnit[][])new MapUnit[][]{{WALL_UNIT, FLOOR_UNIT, WALL_UNIT}, {FLOOR_UNIT, FLOOR_UNIT, FLOOR_UNIT}, {WALL_UNIT, FLOOR_UNIT, WALL_UNIT}}, new MapTileEdge[]{HALLWAY_EDGE, HALLWAY_EDGE, HALLWAY_EDGE, HALLWAY_EDGE}, new MapTileOrientation[]{MapTileOrientation.UPRIGHT}, new MapTileEdgePosition[]{MapTileEdgePosition.TOP, MapTileEdgePosition.RIGHT, MapTileEdgePosition.BOTTOM, MapTileEdgePosition.LEFT});
        MAP_TILE_TYPES = new MapTileType[]{OPEN_FLOOR_TYPE, ONE_CORNER_WALL_TYPE, TWO_CORNER_WALL_TYPE, WALL_TYPE, DOORWAY_TYPE, CORNER_TYPE, RIGHT_DOOR_CORNER_TYPE, LEFT_DOOR_CORNER_TYPE, TWO_DOOR_CORNER_TYPE, STRAIGHT_HALLWAY_TYPE, CORNER_HALLWAY_TYPE, THREE_WAY_HALLWAY_TYPE, FOUR_WAY_HALLWAY_TYPE};
        COLOR_MAP = new HashMap<MapUnit, Color>();
        COLOR_MAP.put(FLOOR_UNIT, new Color(170, 170, 170));
        COLOR_MAP.put(WALL_UNIT, new Color(85, 85, 85));
        COLOR_MAP.put(DOOR_UNIT, new Color(255, 0, 255));
    }
}

