/*
 * Decompiled with CFR 0.152.
 */
package org.flexgen.example;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.flexgen.example.DungeonExample;
import org.flexgen.map.MapGenerator;
import org.flexgen.map.MapTile;
import org.flexgen.map.MapTileAddedListener;
import org.flexgen.map.MapTileEdge;
import org.flexgen.map.MapTileEdgePosition;
import org.flexgen.map.MapTileLocation;
import org.flexgen.map.MapTileLocationFilter;
import org.flexgen.map.MapTileRemovedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoorwayMapTileLocationFilter
implements MapTileLocationFilter,
MapTileAddedListener,
MapTileRemovedListener {
    private Set<MapTileLocation> excludedMapTileLocations = new HashSet<MapTileLocation>();

    public int getMinX() {
        return 0;
    }

    public int getMinY() {
        return 0;
    }

    public int getMaxX() {
        return 0;
    }

    public int getMaxY() {
        return 0;
    }

    public Collection<MapTileLocation> getFilteredMapTileLocations(Collection<MapTileLocation> mapTileLocations) {
        LinkedList<MapTileLocation> localMapTileLocations = new LinkedList<MapTileLocation>();
        for (MapTileLocation mapTileLocation : mapTileLocations) {
            if (this.excludedMapTileLocations.contains(mapTileLocation)) continue;
            localMapTileLocations.add(mapTileLocation);
        }
        return localMapTileLocations;
    }

    public void mapTileAdded(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        for (MapTileLocation neighborMapTileLocation : mapTileLocation.getNeighborLocations()) {
            this.checkMapTileLocation(mapGenerator, neighborMapTileLocation);
        }
    }

    public void mapTileRemoved(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        for (MapTileLocation neighborMapTileLocation : mapTileLocation.getNeighborLocations()) {
            this.checkMapTileLocation(mapGenerator, neighborMapTileLocation);
        }
    }

    public void clear() {
        this.excludedMapTileLocations.clear();
    }

    private void checkMapTileLocation(MapGenerator mapGenerator, MapTileLocation mapTileLocation) {
        this.excludedMapTileLocations.remove(mapTileLocation);
        if (mapGenerator.getMapTile(mapTileLocation) != null) {
            return;
        }
        MapTileEdge topMapTileEdge = null;
        MapTileEdge rightMapTileEdge = null;
        MapTileEdge bottomMapTileEdge = null;
        MapTileEdge leftMapTileEdge = null;
        MapTileLocation tempMapTileLocation = new MapTileLocation(mapTileLocation.getX(), mapTileLocation.getY() - 1);
        MapTile tempMapTile = mapGenerator.getMapTile(tempMapTileLocation);
        if (tempMapTile != null) {
            topMapTileEdge = tempMapTile.getMapTileEdge(MapTileEdgePosition.BOTTOM);
        }
        if ((tempMapTile = mapGenerator.getMapTile(tempMapTileLocation = new MapTileLocation(mapTileLocation.getX() + 1, mapTileLocation.getY()))) != null) {
            rightMapTileEdge = tempMapTile.getMapTileEdge(MapTileEdgePosition.LEFT);
        }
        if ((tempMapTile = mapGenerator.getMapTile(tempMapTileLocation = new MapTileLocation(mapTileLocation.getX(), mapTileLocation.getY() + 1))) != null) {
            bottomMapTileEdge = tempMapTile.getMapTileEdge(MapTileEdgePosition.TOP);
        }
        if ((tempMapTile = mapGenerator.getMapTile(tempMapTileLocation = new MapTileLocation(mapTileLocation.getX() - 1, mapTileLocation.getY()))) != null) {
            leftMapTileEdge = tempMapTile.getMapTileEdge(MapTileEdgePosition.RIGHT);
        }
        if (!(topMapTileEdge != null && topMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE) || rightMapTileEdge != null && rightMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE) || bottomMapTileEdge != null && bottomMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE) || leftMapTileEdge != null && leftMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE))) {
            return;
        }
        if (topMapTileEdge != null && !topMapTileEdge.equals((Object)DungeonExample.WALL_EDGE) && !topMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE)) {
            return;
        }
        if (rightMapTileEdge != null && !rightMapTileEdge.equals((Object)DungeonExample.WALL_EDGE) && !rightMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE)) {
            return;
        }
        if (bottomMapTileEdge != null && !bottomMapTileEdge.equals((Object)DungeonExample.WALL_EDGE) && !bottomMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE)) {
            return;
        }
        if (leftMapTileEdge != null && !leftMapTileEdge.equals((Object)DungeonExample.WALL_EDGE) && !leftMapTileEdge.equals((Object)DungeonExample.DOORWAY_EDGE)) {
            return;
        }
        this.excludedMapTileLocations.add(mapTileLocation);
    }
}

